/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.objets;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionObjet;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import org.apache.log4j.Logger;

public class Objet {
    private static Logger log = Logger.getLogger(Objet.class);
    private long idObjet;
    private String libelle;
    private String valeur;

    public Objet(PKCS11 pKCS11, long l, long l2) throws ExceptionObjet {
        this.idObjet = l2;
        this.chargeInfo(pKCS11, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void chargeInfo(PKCS11 pKCS11, long l) throws ExceptionObjet {
        if (pKCS11 != null) {
            try {
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
                cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE();
                cK_ATTRIBUTEArray[0].type = 3L;
                cK_ATTRIBUTEArray[1] = new CK_ATTRIBUTE();
                cK_ATTRIBUTEArray[1].type = 17L;
                pKCS11.C_GetAttributeValue(l, this.idObjet, cK_ATTRIBUTEArray);
                if (cK_ATTRIBUTEArray == null || cK_ATTRIBUTEArray.length == 0) return;
                try {
                    this.libelle = new String((char[])cK_ATTRIBUTEArray[0].pValue);
                    this.valeur = TraitementsUtil.getHexadecimal((byte[])cK_ATTRIBUTEArray[1].pValue, 16);
                    return;
                }
                catch (ClassCastException classCastException) {
                    log.error((Object)("Une erreur est survenue lors de la recuperation des informations de l'objet : " + ExceptionProgrammeExemple.getStacktrace(classCastException)));
                    throw new ExceptionObjet(206, "Une erreur est survenue lors de la r\u00e9cuperation des informations de l'objet");
                }
            }
            catch (PKCS11Exception pKCS11Exception) {
                log.error((Object)("Une erreur est survenue lors de la recuperation des informations de l'objet : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                throw new ExceptionObjet(206, "Une erreur est survenue lors de la r\u00e9cuperation des informations de l'objet");
            }
        } else {
            log.error((Object)"La librairie est nulle");
            throw new ExceptionObjet(206, "La librairie est nulle");
        }
    }

    public long getIdObjet() {
        return this.idObjet;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public String getValeur() {
        return this.valeur;
    }
}

